<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use App\Http\Resources\LastSoldFooditemsResource;
use App\Models\Expense;
use App\Models\Sale;
use App\Models\SaleItem;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class DashboardController extends ApiController
{
    /**
     * Construct middleware
     */
    public function __construct()
    {
        $this->middleware('auth:sanctum');
    }

    /**
     * Dashboard states
     *
     * @param      \Illuminate\Http\Request  $request  The request
     *
     * @return     JsonResponse              The json response.
     */
    public function states(Request $request): JsonResponse
    {
        $saleModel = Sale::class;
        $duration = $request->is_duration;
        return response()->json(
            [
                'total_price_amount' => $this->calculateAmountFromModel($saleModel, 'cart_total_price', $duration),
                'last_total_price_amount' => $this->calculateAmountFromModel($saleModel, 'cart_total_price', $duration, true),

                'total_cost_amount' => $this->calculateAmountFromModel($saleModel, 'cart_total_cost', $duration),
                'last_total_cost_amount' => $this->calculateAmountFromModel($saleModel, 'cart_total_cost', $duration, true),

                'total_discount_amount' => $this->calculateAmountFromModel($saleModel, 'discount_amount', $duration),
                'last_total_discount_amount' => $this->calculateAmountFromModel($saleModel, 'discount_amount', $duration, true),

                'total_payable_amount' => $this->calculateAmountFromModel($saleModel, 'payable_after_all', $duration),
                'last_total_payable_amount' => $this->calculateAmountFromModel($saleModel, 'payable_after_all', $duration, true),

                'total_profit_amount' => $this->calculateAmountFromModel($saleModel, 'profit_after_all', $duration),
                'last_total_profit_amount' => $this->calculateAmountFromModel($saleModel, 'profit_after_all', $duration, true),

                'total_tax_amount' => $this->calculateAmountFromModel($saleModel, 'tax_amount', $duration),
                'last_total_tax_amount' => $this->calculateAmountFromModel($saleModel, 'tax_amount', $duration, true),

                'total_tip_amount' => $this->calculateAmountFromModel($saleModel, 'tip_amount', $duration),
                'last_total_tip_amount' => $this->calculateAmountFromModel($saleModel, 'tip_amount', $duration, true),

                'expense_amount' => $this->calculateAmountFromModel(Expense::class, 'amount', $duration),
                'last_expense_amount' => $this->calculateAmountFromModel(Expense::class, 'amount', $duration, true),

                'chart' => $this->generateChartFromModel($saleModel, 'payable_after_all', $duration),
                'last_chart' => $this->generateChartFromModel($saleModel, 'payable_after_all', $duration, true),

                'last_sold_items' => LastSoldFooditemsResource::collection(SaleItem::limit(10)->latest()->get()),
            ]
        );
    }

    /**
     * Dashboard annual graph
     *
     * @param      \Illuminate\Http\Request  $request  The request
     *
     * @return     JsonResponse              The json response.
     */
    public function annualGraph(Request $request): JsonResponse
    {
        $graph = [];
        $month = 1;
        while ($month <= 12) {
            $graph[] = Sale::filter($request->all())->whereNotNull('completed_at')
                ->whereMonth('created_at', '=', $month)
                ->count();
            $month++;
        }
        return response()->json($graph);
    }
}
