<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use App\Http\Requests\TaxStoreRequest;
use App\Http\Resources\TaxResource;
use App\Models\Tax;
use Illuminate\Http\Request;

class TaxController extends ApiController
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return response()->json(TaxResource::collection(Tax::get()));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(TaxStoreRequest $request)
    {
        $tax = Tax::create($request->validated());
        return response()->json([
            'message' => __('Data saved successfully'),
            'tax' => new TaxResource($tax)
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(Tax $tax)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(TaxStoreRequest $request, Tax $tax)
    {
        $tax->update($request->validated());
        return response()->json([
            'message' => __('Data updated successfully'),
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Tax $tax)
    {
        $tax->delete();
        return response()->json([
            'message' => __('Data removed successfully'),
        ]);
    }
}
