<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class GuestRoomReservationStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'customer_id' => 'required',
            'guest_room_id' => 'required',
            'booking_source_id' => 'required',
            'reserved_at_date' => 'required',
            'reserved_at_time' => 'required',
            'reserved_till_date' => 'required',
            'reserved_till_time' => 'required',
            'reservation_status_id' => 'required',
            'tax' => 'required|array',
            'payments' => 'sometimes',
            'tax_amount' => 'required',
            'reservation_hours' => 'required',
            'per_hour_charges' => 'required',
            'sub_total' => 'required',
            'staff_note' => 'sometimes',
            'note' => 'required',
            'total_room_service_charges' => 'required',
            'checkin_process' => 'sometimes',
        ];
    }
}
