<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PickupPointStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'place_title' => 'required|unique:pickup_points',
            'person_name' => 'nullable|max:255',
            'phone' => 'nullable',
            'address' => 'nullable',
        ];
    }
}
