<?php

namespace App\Http\Resources;

use App\Http\Resources\CashbookSaleDetailResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CashBookResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'user' => $this->user->name,
            'opening_amount' => $this->opening_amount,
            'closed' => $this->closed,
            'sales_amount' => $this->getSalesTotalAmount(),
            'discount_amount' => $this->getSalesTotalDiscountAmount(),
            'tax_amount' => $this->getSalesTotalTaxAmount(),
            'total_profit' => $this->getSalesTotalProfitAmount(),
            'sold_items' => $this->getSalesTotalItems(),
            'sales' => $this->getSalesTotalOrders(),
            'in_progress' => $this->getInProgress(),
            'in_completed' => $this->getInCompleted(),
            'in_cancelled' => $this->getInCancelled(),
            'is_closable' => $this->canBeClosed(),
            'orders' => CashbookSaleDetailResource::collection($this->sales),
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
