<?php

namespace App\Http\Resources;

use App\Http\Resources\PosModifierResource;
use App\Http\Resources\IngredientWithPivotResource;
use Illuminate\Http\Resources\Json\JsonResource;

class PosFoodItemAttributeDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'food_item_id' => $this->foodItem->id,
            'food_item_name' => $this->foodItem->name,
            'name' =>  $this->name,
            'image' =>  $this->foodItem->getImage(),
            'price' => $this->price,
            'cost' => $this->cost,
            'sku' => $this->sku,
            'ingredients' => IngredientWithPivotResource::collection($this->ingredients),
            'modifiers' => PosModifierResource::collection($this->getModifiers()),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            //'in_stock' => $this->getTotalInStock(),
            'in_stock' => 200,
        ];
    }
}
