<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PosGuestRoomReservationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'customer' => new CustomerResource($this->customer),
            'guest_room' => new GuestRoomResource($this->guestRoom),
            'checkin_at' => $this->checkin_at,
            'checkout_at' => $this->checkout_at,
            'payment_cleared' => $this->payment_cleared,
            'payments' => $this->payments ?? [],
            'note' => $this->note,
            'staff_note' => $this->staff_note,
            'tax_amount' => $this->tax_amount,
            'tax' => $this->tax,
            'sales_tax_amount' => $this->getSalesTaxAmount(),
            'sale_discount_amount' => $this->getSalesDiscountAmount(),
            'sales_payable_amount' => $this->getSalesPayableAmount(),
            'sales_items' => $this->getSalesItems(),
            'sales_orders' => $this->getSalesOrders(),
            'total_room_service_charges' => $this->total_room_service_charges,
            'reservation_hours' => $this->reservation_hours,
            'sub_total' => $this->sub_total,
            'created_at' => $this->updated_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
