<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class GuestRoomReservationFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * User dataTable search query
     *
     * @param mixed $search query
     *
     * @return GuestRoomReservationFilter
     */
    public function search($search): GuestRoomReservationFilter
    {
        return $this->where('tracking', 'LIKE', '%' . $search . '%');
    }

    /**
     * Filtering by starting date
     *
     * @param      mixed            $startdate  The startdate
     *
     * @return     GuestRoomReservationFilter  The repair order filter.
     */
    public function startdate($startdate): GuestRoomReservationFilter
    {
        return $this->where('created_at', '>', $startdate);
    }

    /**
     * Filtering by ending date date
     *
     * @param      mixed        $period  The period
     *
     * @return     GuestRoomReservationFilter  The repair order filter.
     */
    public function enddate($enddate): GuestRoomReservationFilter
    {
        return $this->where('created_at', '<', $enddate);
    }

    /**
     * Filtering by by day
     *
     * @param      mixed           $isDuration  The duration
     *
     * @return     GuestRoomReservationFilter  The repair order filter.
     */
    public function isDuration($isDuration): GuestRoomReservationFilter
    {
        if ('day' == $isDuration) {
            return $this->whereDay('created_at', '=', date('d'));
        }
        if ('month' == $isDuration) {
            return $this->whereMonth('created_at', '=', date('m'));
        }
        if ('year' == $isDuration) {
            return $this->whereYear('created_at', '=', date('Y'));
        }
        return $this;
    }

    public function customer($customer): GuestRoomReservationFilter
    {
        return $this->where('customer_id', '=', $customer);
    }

    public function guestRoom($guestRoom): GuestRoomReservationFilter
    {
        return $this->where('guest_room_id', '==', $guestRoom);
    }

    public function bookingSource($bookingSource): GuestRoomReservationFilter
    {
        return $this->where('booking_source_id', '==', $bookingSource);
    }

    public function reservationStatus($reservationStatus): GuestRoomReservationFilter
    {
        return $this->where('reservation_status_id', '=', $reservationStatus);
    }
}
