<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->boolean('is_discount_in_percentage')->default(true);
            $table->text('shipping_address')->nullable();
            $table->foreignId('pickup_point_id')->nullable()->constrained('pickup_points');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->dropForeign(['pickup_point_id']);

            $table->dropColumn('is_discount_in_percentage');
            $table->dropColumn('shipping_address');
            $table->dropColumn('pickup_point_id');
        });
    }
};
