<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        $seeds = [
            UserRoleSeeder::class,
            UserSeeder::class,
            LanguageSeeder::class,
            SettingSeeder::class,
            CustomerSeeder::class,
            ServiceTableSeeder::class,
            IngredientSeeder::class,
            IngredientSeeder::class,
            PaymentMethodSeeder::class,
            ExpenseTypeSeeder::class,
            GuestRoomSeeder::class,
            BookingSourceSeeder::class,
            ReservationStatausSeeder::class,
            TaxSeeder::class,
        ];

        if (!config('app.demo_mode')) {
            array_push($seeds, FoodCategorySeeder::class);
        }

        $this->call($seeds);
    }
}
